PSCAD 4.2.0

Settings
 {
 Id = "955649630.1144860677"
 Author = "johnn.jayas"
 Desc = "Phase Controlled AC Switch"
 Arch = "windows"
 Options = 0
 Build = 18
 Warn = 1
 Check = 7
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 0.00025
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 255
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "ass3.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 1
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }

 }

Definitions
 {
 Module("RunTime")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,White)
   Rectangle(-29,-12,29,12)
   Text(0,27,"%:Name")
   Text(0,42,"%:Desc")
   }


  Page(A/A4,Landscape,1,[597,467],100)
   {
   }
  }
 Module("Main")
  {
  Desc = " "
  FileDate = 1144860642
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(A/A4,Portrait,0,[597,467],100)
   {
   -Wire-([270,450],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([342,450],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([342,414],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.resistor([450,468],1,0,-1)
    {
    R = "10.0 [ohm]"
    }
   0.ground([450,558],1,0,-1)
    {
    }
   0.inductor([450,522],1,0,-1)
    {
    L = "0.0265 [H]"
    }
   -Wire-([450,522],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.datalabel([162,630],0,0,-1)
    {
    Name = "Vload"
    }
   0.pgb([198,630],0,25678304,50)
    {
    Name = "Vload"
    Group = ""
    Display = "0"
    Scale = "1.0e3"
    Units = "V"
    mrun = "0"
    Pol = "0"
    Min = "-400"
    Max = "400"
    }
   -Wire-([162,630],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.voltmetergnd([396,414],0,0,20)
    {
    Name = "Vload"
    }
   0.datalabel([162,666],0,0,-1)
    {
    Name = "Vsource"
    }
   0.pgb([198,666],0,25334560,70)
    {
    Name = "Vsource"
    Group = ""
    Display = "0"
    Scale = "1.0e3"
    Units = "V"
    mrun = "0"
    Pol = "0"
    Min = "-400"
    Max = "400"
    }
   -Wire-([162,666],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.ammeter([450,432],1,0,30)
    {
    Name = "Iload"
    }
   0.datalabel([162,702],0,0,-1)
    {
    Name = "Iload"
    }
   0.pgb([198,702],0,38943080,80)
    {
    Name = "Iload"
    Group = ""
    Display = "0"
    Scale = "1.0e3"
    Units = "A"
    mrun = "0"
    Pol = "0"
    Min = "-10"
    Max = "10"
    }
   -Wire-([162,702],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.vco([450,1242],0,0,110)
    {
    Mode = "1"
    }
   -Wire-([522,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([126,936],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([180,1008],0,0,-1)
    {
    Vertex="0,0;0,-126"
    }
   0.datalabel([558,1242],2,0,-1)
    {
    Name = "VCO"
    }
   -Wire-([180,882],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([288,846],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([288,1008],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.const([378,1242],0,0,100)
    {
    Name = ""
    Value = "60.0"
    }
   0.annotation([270,774],0,0,-1)
    {
    AL1 = "THYRISTOR FIRING PULSE"
    AL2 = "CONTROL CIRCUIT"
    }
   0.peswitch([288,378],5,0,220)
    {
    L = "1"
    Type = "1"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.001 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "50000 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.datalabel([324,342],2,0,-1)
    {
    Name = "FP1"
    }
   0.peswitch([324,450],7,0,210)
    {
    L = "2"
    Type = "1"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.001 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "50000 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.datalabel([288,486],0,0,-1)
    {
    Name = "FP2"
    }
   0.voltmetergnd([216,414],0,0,10)
    {
    Name = "Vsource"
    }
   0.datalabel([342,918],0,0,-1)
    {
    Name = "FP1"
    }
   0.datalabel([342,1044],0,0,-1)
    {
    Name = "FP2"
    }
   0.annotation([216,522],0,0,-1)
    {
    AL1 = "240 V, 60 Hz"
    AL2 = "AC Source"
    }
   -Wire-([162,486],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.var([90,936],0,25524320,40)
    {
    Name = "Alpha Order"
    Group = ""
    Display = "0"
    Max = "175"
    Min = "5"
    Value = "125.7"
    Units = "deg"
    Collect = "1"
    }
   -Wire-([162,414],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.source_1([162,522],1,0,-1)
    {
    Name = "AC Source"
    Type = "6"
    Grnd = "1"
    Spec = "0"
    Cntrl = "0"
    AC = "1"
    Vm = "240.0 [V]"
    Tc = "0.01 [s]"
    Ph = "0.0 [deg]"
    f = "60.0 [Hz]"
    P = "0.0 [MW]"
    Q = "0.0 [MVAR]"
    R = "1.0 [ohm]"
    Rs = "1.0 [ohm]"
    Rp = "1.0 [ohm]"
    Lp = "0.1 [H]"
    R' = "1.0 [ohm]"
    L = "0.1 [H]"
    C = "1.0 [uF]"
    L' = "0.1 [H]"
    C' = "1.0 [uF]"
    CUR = ""
    }
   0.annotation([396,558],0,0,-1)
    {
    AL1 = "RL Load"
    AL2 = ""
    }
   -Wire-([450,414],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([324,450],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([270,450],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([324,378],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([270,378],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.pin([342,414],0,0,-1)
    {
    }
   0.pin([270,414],0,0,-1)
    {
    }
   0.datalabel([288,846],2,0,-1)
    {
    Name = "VCO"
    }
   -Sticky-([90,1188],0)
    {
    Name = ""
    Font = 1
    Bounds = 90,1188,288,1314
    Alignment = 0
    Style = 1
    Arrow = 8
    Color = 0,15792890
    Text = "\
This is the Voltage-Controlled Oscillator (VCO)  component.
For an input in Hz, it will output a repeating, 0 to 360 degree 
ramp function waveform. This waveform is used for reference in the above control circuit.
"
    }
   -Sticky-([288,1098],0)
    {
    Name = ""
    Font = 1
    Bounds = 288,1098,450,1152
    Alignment = 0
    Style = 1
    Arrow = 16
    Color = 0,15792890
    Text = "Adds 180 degrees to Alpha Order for negative half cycle firing pulse."
    }
   0.datalabel([378,648],0,0,-1)
    {
    Name = "FP1"
    }
   0.pgb([414,666],0,24900288,180)
    {
    Name = "FP1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([378,648],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([378,684],0,0,-1)
    {
    Name = "FP2"
    }
   0.pgb([414,702],0,38446976,170)
    {
    Name = "FP2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([378,684],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([270,630],0,0,-1)
    {
    Name = "Alpha"
    }
   0.pgb([306,630],0,25189424,90)
    {
    Name = "Alpha"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "400"
    }
   -Wire-([270,630],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([270,702],0,0,-1)
    {
    Name = "VCO"
    }
   0.pgb([306,702],0,25702944,190)
    {
    Name = "VCO"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "400"
    }
   -Wire-([270,702],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([144,936],0,0,-1)
    {
    Name = "Alpha"
    }
   0.fp_int([342,846],0,0,120)
    {
    Type = "0"
    PNum = "0"
    Blck = "0"
    PFormat = "0"
    detect = "0"
    max = "360.0"
    min = "0.0"
    BType = "0"
    PTime = "0.005 [s]"
    }
   0.fp_int([342,972],0,0,150)
    {
    Type = "0"
    PNum = "0"
    Blck = "0"
    PFormat = "0"
    detect = "0"
    max = "360.0"
    min = "0.0"
    BType = "0"
    PTime = "0.005 [s]"
    }
   -Wire-([288,972],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([288,972],2,0,-1)
    {
    Name = "VCO"
    }
   0.annotation([342,504],0,0,-1)
    {
    AL1 = "AC SWITCH"
    AL2 = "CIRCUIT"
    }
   0.datatap([414,666],0,0,140)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "0"
    }
   0.datatap([414,702],0,0,160)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "0"
    }
   0.const([252,1080],3,0,60)
    {
    Name = ""
    Value = "180"
    }
   0.sumjct([252,1008],0,0,130)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   -Wire-([180,1008],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([270,666],0,0,-1)
    {
    Name = "Alpha2"
    }
   0.pgb([306,666],0,38176832,200)
    {
    Name = "Alpha2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "400"
    }
   -Wire-([270,666],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([288,1008],2,0,-1)
    {
    Name = "Alpha2"
    }
   -Sticky-([72,990],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,990,162,1044
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Alpha Order Slider and Control"
    }
   -Sticky-([72,90],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,90,540,342
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This case is based on a problem outlined in the text by Joseph Vithayathil called \"Power Electronics: Principles and Applications\". This case was originally created by Dr. Ani Gole, as an assignment for a Power Electronics course at the University of Manitoba.

The AC Switch is an important device in the field of Power Electronics. It is used extensively to control Inductance and Capacitance in Static VAR Compensators (SVC). In essence, the AC Switch can vary the load impedance seen by the source, by varying the firing angle alpha.

QUESTION:
An AC load is supplied from a 240 V, 60 Hz supply. The load consists of a resistance of 10 Ohms in series with an unknown inductance. When the phase controlled AC thyristor switch is used with it, no change in the AC current or voltage is noticed for firing delay angles up to 45 deg. What is the expected value of the inductance?"
    }
   -Sticky-([396,36],0)
    {
    Name = ""
    Font = 2
    Bounds = 396,36,774,72
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "PHASE CONTROLLED  AC SWITCH"
    }
   -ControlPanel-([72,756],0)
    {
    Name = "Alpha Control"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,72,126
    Slider(25524320)
    }
   -Sticky-([630,90],0)
    {
    Name = ""
    Font = 1
    Bounds = 630,90,1152,360
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
SOLUTION:
The term \"Phase Control\" means that the AC switch is fired every half-cycle. Therefore, each thyristor is fired once per cycle.

Due to the inductive part of the load, the current will rise and decay exponentially according to L*di/dt. Thyristors require a zero current before they will turn-off. Therefore, there will exist a minimum firing angle - below which the thyristors will never turn-off. This is the circuit \"critical angle\" and occurs when the firing angle alpha equals the circuit phase angle.

This angle is given as 45 deg. At this angle, the transient part of the current becomes zero - leaving only the steady- state current. From this clue, the \"critical inductance\" can be found.

In this case we know that the phase (critical) angle is 45 degrees. Then, XL = R*tan(45) and so XL = R = 10 Ohms. Therefore, L = XL/2*pi*f  = 26.5 mH (at 60 Hz).
"
    }
   -Plot-([630,378],0)
    {
    Title = ""
    Draw = 1
    Area = [0,0,0,0]
    Posn = [-1,-1]
    Icon = [-1,-1]
    Extents = 0,0,504,738
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,504,160],"Voltage")
     {
     Options = 8
     Units = "V"
     Curve(25678304,"Vload",0,,,)
     Curve(25334560,"Vsource",1,,,)
     }
    Graph([0,160],[0,0,504,160],"Current")
     {
     Options = 8
     Units = "A"
     Curve(38943080,"Iload",0,,,)
     }
    Graph([0,320],[0,0,504,160],"deg")
     {
     Options = 8
     Units = ""
     Curve(25189424,"Alpha",0,,,)
     Curve(25702944,"VCO",1,,,)
     Curve(38176832,"Alpha2",2,,,)
     }
    DGraph([0,480],[0,0,504,195],"DigitalGraph")
     {
     Options = 2
     Curve(24900288,"FP1",0,,,)
     Curve(38446976,"FP2",1,,,)
     }
    }
   -Sticky-([396,846],0)
    {
    Name = ""
    Font = 1
    Bounds = 396,846,630,1008
    Alignment = 0
    Style = 1
    Arrow = 80
    Color = 0,15792890
    Text = "\
Interpolated Firing Pulse Generators. 

These components will compare the alpha order in degrees with the output from the VCO. The output firing pulse is an array of 2 values. The first is a 0 or 1 and represents the actual gate pulse. The second is information regarding the interpolated switching time."
    }
   0.datalabel([666,1314],0,0,-1)
    {
    Name = "Vsource"
    }
   0.rms-inst([702,1314],0,0,-1)
    {
    Type = "0"
    Ts = "0.02 [s]"
    Scale = "1.0"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   -Wire-([738,1314],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.pgb([810,1314],0,24970080,-1)
    {
    Name = "Vsrc_rms"
    Group = ""
    Display = "0"
    Scale = "1.0e3"
    Units = "V"
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   -Plot-([504,1350],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,576,198]
    Posn = [504,1350]
    Icon = [-1,-1]
    Extents = 0,0,576,198
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,576,135],"Vsrc_rms")
     {
     Options = 0
     Units = ""
     Curve(24970080,"Vsrc_rms",0,,,)
     }
    }
   }
  }
 }

